% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_channel_err.R
\name{tg_channel_err}
\alias{tg_channel_err}
\title{Obtaining an ERR indicator for a channel in dynamics}
\usage{
tg_channel_err(
  channel_id = tg_get_channel_id(),
  start_date = Sys.Date() - 15,
  end_date = Sys.Date(),
  group = c("day", "week", "month")
)
}
\arguments{
\item{channel_id}{Channel ID (@username, t.me/username, t.me/joinchat/AAAAABbbbbcccc ... or channel ID in 'TGStat')}

\item{start_date}{Start date of report period}

\item{end_date}{End date of report period}

\item{group}{Time group: day, week, month}
}
\value{
tibble with channel ERR dinamics
}
\description{
Allows you to get the "ERR" indicator in dynamics by day, week, month.
}
\details{
For the \code{group = 'day'} grouping, the value for the "average coverage of publications" as of the end of the day will be returned.
For groupings \code{group = 'week'} and \code{group = 'month'}, the value of the indicator "average coverage of publications" at the end of the last day of the period (week or month) will be returned.
By default, the result will be returned for the last 10 days. However, you can specify the required period using the \code{start_date} and \code{end_date} parameters, while observing the restrictions on your tariff.
Depending on the requested grouping type group - the \code{period} field will take one of the following formats:
\itemize{
\item day: Y-m-d
\item week: Y-W
\item month: Y-m
}
}
\examples{
\dontrun{
tg_set_channel_id('R4marketing')
err <- tg_channel_err()
}
}
\references{
See also \href{https://api.tgstat.ru/docs/ru/channels/err.html}{TGStat API Documentation of metrod channels/err}
}
