% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{cbind_rtables}
\alias{cbind_rtables}
\title{Column-bind two \code{TableTree} objects}
\usage{
cbind_rtables(x, ...)
}
\arguments{
\item{x}{(\code{TableTree} or \code{TableRow})\cr a table or row object.}

\item{...}{one or more further objects of the same class as \code{x}.}
}
\value{
A formal table object.
}
\description{
Column-bind two \code{TableTree} objects
}
\examples{
x <- rtable(c("A", "B"), rrow("row 1", 1, 2), rrow("row 2", 3, 4))
y <- rtable("C", rrow("row 1", 5), rrow("row 2", 6))
z <- rtable("D", rrow("row 1", 9), rrow("row 2", 10))

t1 <- cbind_rtables(x, y)
t1

t2 <- cbind_rtables(x, y, z)
t2

col_paths_summary(t1)
col_paths_summary(t2)

}
