% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{additional_fun_params}
\alias{additional_fun_params}
\title{Additional parameters within analysis and content functions (\code{afun}/\code{cfun})}
\description{
It is possible to add specific parameters to \code{afun} and \code{cfun}, in \code{\link[=analyze]{analyze()}} and \code{\link[=summarize_row_groups]{summarize_row_groups()}},
respectively. These parameters grant access to relevant information like the row split structure (see
\link{spl_context}) and the predefined baseline (\code{.ref_group}).
}
\details{
We list and describe all the parameters that can be added to a custom analysis function below:

\describe{
\item{.N_col}{Column-wise N (column count) for the full column being tabulated within.}
\item{.N_total}{Overall N (all observation count, defined as sum of column counts) for the tabulation.}
\item{.N_row}{Row-wise N (row group count) for the group of observations being analyzed (i.e. with no
column-based subsetting).}
\item{.df_row}{\code{data.frame} for observations in the row group being analyzed (i.e. with no column-based
subsetting).}
\item{.var}{Variable being analyzed.}
\item{.ref_group}{\code{data.frame} or vector of subset corresponding to the \code{ref_group} column including subsetting
defined by row-splitting. Only required/meaningful if a \code{ref_group} column has been defined.}
\item{.ref_full}{\code{data.frame} or vector of subset corresponding to the \code{ref_group} column without subsetting
defined by row-splitting. Only required/meaningful if a \code{ref_group} column has been defined.}
\item{.in_ref_col}{Boolean indicating if calculation is done for cells within the reference column.}
\item{.spl_context}{\code{data.frame} where each row gives information about a previous 'ancestor' split state.
See \link{spl_context}.}
\item{.alt_df_row}{\code{data.frame}, i.e. the \code{alt_count_df} after row splitting. It can be used with
\code{.all_col_exprs} and \code{.spl_context} information to retrieve current faceting, but for \code{alt_count_df}.
It can be an empty table if all the entries are filtered out.}
\item{.alt_df}{\code{data.frame}, \code{.alt_df_row} but filtered by columns expression. This data present the same
faceting of main data \code{df}. This also filters \code{NA}s out if related parameters are set to do so (e.g. \code{inclNAs}
in \code{\link[=analyze]{analyze()}}). Similarly to \code{.alt_df_row}, it can be an empty table if all the entries are filtered out.}
\item{.all_col_exprs}{List of expressions. Each of them represents a different column splitting.}
\item{.all_col_counts}{Vector of integers. Each of them represents the global count for each column. It differs
if \code{alt_counts_df} is used (see \code{\link[=build_table]{build_table()}}).}
}
}
\note{
If any of these formals is specified incorrectly or not present in the tabulation machinery, it will be
treated as if missing. For example, \code{.ref_group} will be missing if no baseline is previously defined during
data splitting (via \code{ref_group} parameters in, e.g., \code{\link[=split_rows_by]{split_rows_by()}}). Similarly, if no \code{alt_counts_df} is
provided to \code{\link[=build_table]{build_table()}}, \code{.alt_df_row} and \code{.alt_df} will not be present.
}
