% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{export_as_pdf}
\alias{export_as_pdf}
\title{Export as PDF}
\usage{
export_as_pdf(
  tt,
  file,
  width = 11.7,
  height = 8.3,
  margins = c(4, 4, 4, 4),
  fontsize = 8,
  paginate = TRUE,
  lpp = NULL,
  hsep = "-",
  indent_size = 2,
  ...
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{file}{file to write, must have \code{.pdf} extension}

\item{width}{the width and height of the graphics region in inches}

\item{height}{the width and height of the graphics region in inches}

\item{margins}{ A numeric vector interpreted in the same way
    as \code{par(mar)} in base graphics. }

\item{fontsize}{the size of text (in points)}

\item{paginate}{logical(1). Should \code{tt} be paginated before writing the file.}

\item{lpp}{numeric. Maximum lines per page including (re)printed header and context rows}

\item{hsep}{character(1). Set of character(s) to be repeated as the separator between
the header and body of the table when rendered as text. Defaults to a connected horrizontal
line (unicode 2014) in locals that use a UTF charset, and to \code{-} elsewhere (with a
once per session warning).}

\item{indent_size}{numeric(1). Number of spaces to use per indent level. Defaults to 2}

\item{...}{arguments passed on to \code{paginate_table}}
}
\description{
The PDF output is based on the ASCII output created with \code{toString}
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2", "COUNTRY"))

tbl <- build_table(lyt, ex_adsl)

\dontrun{
tf <- tempfile(fileext = ".pdf")
export_as_pdf(tbl, file = tf, height = 4)
tf <- tempfile(fileext = ".pdf")
export_as_pdf(tbl, file = tf, lpp = 8)
}

}
\seealso{
\code{export_as_txt}
}
