% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uninstallPackage.R
\name{uninstallPackage}
\alias{uninstallPackage}
\alias{uninstallPackage,ANY,ANY,character-method}
\alias{uninstallPackage,ANY,ANY,missingOrNULL-method}
\alias{uninstallPackage,ANY,ANY,Session-method}
\title{Removes a package from SyncroSim installation}
\usage{
uninstallPackage(packages, versions = NULL, session = NULL)

\S4method{uninstallPackage}{ANY,ANY,character}(packages, versions = NULL, session = NULL)

\S4method{uninstallPackage}{ANY,ANY,missingOrNULL}(packages, versions = NULL, session = NULL)

\S4method{uninstallPackage}{ANY,ANY,Session}(packages, versions = NULL, session = NULL)
}
\arguments{
\item{packages}{character or character vector. The name(s) of the package(s)
to uninstall}

\item{versions}{character or character vector. The version(s) of the
package(s) to uninstall. If \code{NULL} then will uninstall all versions of
the package(s).}

\item{session}{\code{\link{Session}} object. If \code{NULL} (default),
\code{session()} will be used}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful
removal) and \code{FALSE} upon failure.
}
\description{
Removes a package from SyncroSim installation
}
\examples{
\dontrun{
# Set SyncroSim session
mySession <- session()

# Install packages to SyncroSim session
installPackages(packages = c("stsim", "stsim"),
                versions = c("4.0.0", "4.0.1"))

# Uninstalls specific version of package from SyncroSim session
uninstallPackage(packages = "stsim", versions = "4.0.0", session = mySession)

# Uninstalls all instances ofa package from SyncroSim session
uninstallPackage(packages = "stsim", session = mySession)
}

}
