% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silent.R
\name{silent}
\alias{silent}
\alias{silent,Session-method}
\alias{silent,missingOrNULLOrChar-method}
\alias{silent<-}
\alias{silent<-,character-method}
\alias{silent<-,Session-method}
\title{Silent status of SyncroSim Session}
\usage{
silent(session)

\S4method{silent}{Session}(session)

\S4method{silent}{missingOrNULLOrChar}(session)

silent(session) <- value

\S4method{silent}{character}(session) <- value

\S4method{silent}{Session}(session) <- value
}
\arguments{
\item{session}{\code{\link{Session}} object or character (i.e. filepath to a 
session). If \code{NULL}, \code{session()} will be used}

\item{value}{logical. If \code{TRUE} (default), the SyncroSim Session will be 
silent}
}
\value{
A logical: \code{TRUE} if the session is silent and \code{FALSE} otherwise.
}
\description{
Checks or sets whether a SyncroSim \code{\link{Session}} is silent or not. In
a silent session, warnings from the console are ignored.
}
\examples{
\donttest{
# Set up a SyncroSim Session
mySession <- session()

# Check the silent status of a SyncroSim Session
silent(mySession)

# Set the silent status of a SyncroSim Session
silent(mySession) <- FALSE
}

}
