% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasheetRaster.R
\name{datasheetRaster}
\alias{datasheetRaster}
\alias{datasheetRaster,character-method}
\alias{datasheetRaster,list-method}
\alias{datasheetRaster,SsimObject-method}
\alias{datasheetRaster,Scenario-method}
\title{Retrieve spatial data from a SyncroSim Datasheet}
\usage{
datasheetRaster(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  subset = NULL,
  forceElements = FALSE
)

\S4method{datasheetRaster}{character}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  subset = NULL,
  forceElements = FALSE
)

\S4method{datasheetRaster}{list}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  subset = NULL,
  forceElements = FALSE
)

\S4method{datasheetRaster}{SsimObject}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  subset = NULL,
  forceElements = FALSE
)

\S4method{datasheetRaster}{Scenario}(
  ssimObject,
  datasheet,
  column = NULL,
  scenario = NULL,
  iteration = NULL,
  timestep = NULL,
  subset = NULL,
  forceElements = FALSE
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Project/Scenario object or list of Scenario objects. If 
SsimLibrary/Project, then \code{scenario} argument is required}

\item{datasheet}{character string. The name of the Datasheet containing the 
raster data}

\item{column}{character string. The name of the column in the datasheet containing 
the file names for raster data. If \code{NULL} (default) then use the first 
column that contains raster file names}

\item{scenario}{character string, integer, or vector of these. The Scenarios to 
include. Required if SsimObject is an SsimLibrary/Project, ignored if 
SsimObject is a list of Scenarios (optional)}

\item{iteration}{integer, character string, or vector of integer/character strings. 
Iteration(s) to include. If \code{NULL} (default) then all iterations are 
included. If no Iteration column is in the Datasheet, then ignored}

\item{timestep}{integer, character string, or vector of integer/character string. 
Timestep(s) to include. If \code{NULL} (default) then all timesteps are 
included.  If no Timestep column is in the Datasheet, then ignored}

\item{subset}{logical expression indicating Datasheet rows to return. 
e.g. expression(grepl("Ts0001", Filename, fixed=T)). See subset() for 
details (optional)}

\item{forceElements}{logical. If \code{TRUE} then returns a single raster as a RasterStack; 
otherwise returns a single raster as a RasterLayer directly. Default is 
\code{FALSE}}
}
\value{
A RasterLayer, RasterStack or RasterBrick object. See raster package documentation for details.
}
\description{
This function retrieves spatial columns from one or more SyncroSim 
\code{\link{Scenario}} Datasheets.
}
\details{
The names of the returned raster stack contain metadata.
For Datasheets without Filename this is: 

\code{paste0(<datasheet name>,".Scn",<scenario id>,".",<tif name>)}.

For Datasheets containing Filename this is: 

\code{paste0(<datasheet name>,".Scn",<scenario id>,".It",<iteration>,".Ts",<timestep>)}.
}
\examples{
\donttest{
# Install the helloworldSpatial package from the server
addPackage("helloworldSpatial")

# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib_datasheetRaster")

# Set up a SyncroSim Session
mySession <- session()

# Use the example template library from helloworldSpatial
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession,
                         package = "helloworldSpatial",
                         template = "example-library",
                         overwrite=TRUE)

# Set up Project and Scenario
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run Scenario to generate results
resultScenario <- run(myScenario)

# Extract specific Datasheet rasters by iteration and timestep
resultRaster <- datasheetRaster(resultScenario,
                  datasheet = "IntermediateDatasheet",
                  column = "OutputRasterFile",
                  iteration = 3,
                  timestep = 2
)

# Extract specific Datasheet rasters using pattern matching
resultDatasheet <- datasheet(resultScenario, name = "IntermediateDatasheet")
head(resultDatasheet)
resultRaster <- datasheetRaster(resultScenario, 
                  datasheet = "IntermediateDatasheet",
                  column = "OutputRasterFile",
                  subset = expression(grepl("ts20", 
                                             resultDatasheet$OutputRasterFile,
                                             fixed = TRUE))
)

# Return the raster Datasheets as a raster stack
resultRaster <- datasheetRaster(resultScenario, 
                 datasheet = "IntermediateDatasheet",
                 column = "OutputRasterFile",
                 forceElements = TRUE
                 )
}

}
