% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cw_text.R
\name{cw_text}
\alias{cw_text}
\title{Capitol words text.json method. Search the congressional record for instances
of a word or phrase.}
\usage{
cw_text(phrase = NULL, title = NULL, date = NULL, start_date = NULL,
  end_date = NULL, chamber = NULL, state = NULL, party = NULL,
  bioguide_id = NULL, congress = NULL, session = NULL, cr_pages = NULL,
  volume = NULL, page = NULL, sort = NULL, as = "table", key = NULL,
  ...)
}
\arguments{
\item{phrase}{Phrase to search.}

\item{title}{Title of page to search.}

\item{date}{Show results for only the given date.}

\item{start_date}{Start date to search on.}

\item{end_date}{End date to search on.}

\item{chamber}{Chamber of congress, House or Senate.}

\item{state}{State, capital two-letter abbreviation (e.g., AK,AZ,NM).}

\item{party}{Political party (one of D,R,I).}

\item{bioguide_id}{Bioguide ID for politician (e.g., B000243)}

\item{congress}{Congressional session (e.g., 110,111,112)}

\item{session}{Session within the current congress (e.g., 1,2)}

\item{cr_pages}{No definition.}

\item{volume}{No definition.}

\item{page}{The page of results to show, 50 results are shown at a time.}

\item{sort}{The value on which to sort the results. You have to specify ascending or descending
(see details), but if you forget, we make it ascending by default (prevents 500 error :)).
See Details.}

\item{as}{(character) One of table (default), list, or response (httr response object).}

\item{key}{Your SunlightLabs API key; loads from .Rprofile.}

\item{...}{Further curl options (debugging tools mostly)}
}
\value{
Phrases matched in a data.frame.
}
\description{
Capitol words text.json method. Search the congressional record for instances
of a word or phrase.
}
\details{
Options for the \code{sort} parameter are:
\itemize{
 \item speaker_state
 \item congress
 \item title
 \item number
 \item volume
 \item chamber
 \item session
 \item id
 \item speaker_party
 \item date
 \item bioguide_id
 \item pages
}

Coupled with a direction, \code{asc} or \code{desc}. An example to sort by true chronological
order and chamber (id works for this purpose) would be \code{id desc}.
}
\examples{
\dontrun{
cw_text(phrase='climate change', start_date='2012-09-16', end_date='2012-09-20')
cw_text(phrase='I would have voted', start_date='2011-09-05', end_date='2011-09-16', party='D')
cw_text(phrase='I would have voted', start_date='2011-09-05', end_date='2011-09-16',
   chamber='House')
cw_text(title='personal explanation', start_date='2011-09-05', end_date='2011-09-16')

library('plyr')
out <- cw_text(phrase='climate change', start_date='2010-01-01', end_date='2012-12-01')
out2 <- ldply(2:6, function(x) cw_text(phrase='climate change', start_date='2010-01-01',
   end_date='2012-12-01', page=x))
rbind(out, out2)

cw_text(phrase='climate change', start_date='2012-09-16', end_date='2012-09-20', sort='title')

# pass in many values for some parametrs
cw_text(phrase=c('climate change', 'politics'), start_date='2012-09-16', end_date='2012-09-20')
}
}

