% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_lobbying}
\alias{ie_lobbying}
\title{Get lobbying details}
\usage{
ie_lobbying(amount = NULL, client_ft = NULL, client_parent_ft = NULL,
  filing_type = NULL, lobbyist_ft = NULL, registrant_ft = NULL,
  transaction_id = NULL, transaction_type = NULL, year = NULL,
  page = NULL, per_page = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{amount}{A YYYY formatted year (1990 - 2010) as a single year or YYYY|YYYY for an OR logic.}

\item{client_ft}{Full-text search on the name of the client for which the lobbyist is working.}

\item{client_parent_ft}{Full-text search on the name of the parent organization of the client.}

\item{filing_type}{Type of filing as identified by CRP. See \url{http://data.influenceexplorer.com/api/lobbying/}.}

\item{lobbyist_ft}{Full-text search on the name of the lobbyist involved in the lobbying activity.}

\item{registrant_ft}{Full-text search on the name of the person or organization filing the lobbyist registration. This is typically the firm that employs the lobbyists. Use the registrant_is_firm field to filter on firms v. individuals.}

\item{transaction_id}{Report ID given by the Senate Office of Public Records.}

\item{transaction_type}{The type of filing as reported by the Senate Office of Public Records. See \url{http://assets.transparencydata.org.s3.amazonaws.com/docs/transaction_types-20100402.csv}.}

\item{year}{A YYYY formatted year (1990 - 2010) as a single year or YYYY|YYYY for an OR logic.}
}
\value{
Details on lobbying.
}
\description{
Get lobbying details
}
\examples{
\dontrun{
ie_lobbying(registrant_ft='Patton Boggs', year=2012, per_page=1)
}
}

