/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.ISubgroup;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;

public class InverseReciprocalQF
implements IQualityFunction {
    private final IQualityFunction innerFunction;

    public InverseReciprocalQF(IQualityFunction innerFunction) {
        this.innerFunction = innerFunction;
    }

    @Override
    public String getID() {
        return "InverseReciprocalQF(" + this.innerFunction.getID() + ")";
    }

    @Override
    public String getName() {
        return "Inverse reciprocal (" + this.innerFunction.getName() + ")";
    }

    @Override
    public boolean isApplicable(ISubgroup<DataRecord> subgroup) {
        return this.innerFunction.isApplicable(subgroup);
    }

    @Override
    public double evaluate(ISubgroup<DataRecord> subgroup) {
        return 1.0 / this.innerFunction.evaluate(subgroup);
    }

    @Override
    public InverseReciprocalQF clone() {
        return new InverseReciprocalQF(this.innerFunction.clone());
    }
}

