/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.operators;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.operators.AbstractAttributeArgumentTerm;

public class Average
extends AbstractAttributeArgumentTerm
implements FormulaNumberElement {
    public Average() {
        super("average");
    }

    public Average(FormulaAttributePrimitive arg) {
        this();
        this.setArg1(arg);
    }

    @Override
    public synchronized Double eval(EvaluationData data) {
        if (this.getArg1() == null || data.getInstances() == null) {
            return null;
        }
        double sum = 0.0;
        int count = 0;
        for (DataRecord inst : data.getInstances()) {
            EvaluationData d = new EvaluationData();
            d.setInstance(inst);
            sum += this.getArg1().eval(d).doubleValue();
            ++count;
        }
        return new Double(sum / (double)count);
    }
}

