% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_test.R
\name{cor_test}
\alias{cor_test}
\title{Correlation Test}
\usage{
cor_test(
  data,
  ...,
  vars = NULL,
  vars2 = NULL,
  alternative = "two.sided",
  method = "pearson",
  conf.level = 0.95,
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{data}{a data.frame containing the variables.}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest. Alternative to the argument
\code{vars}.}

\item{vars}{optional character vector containing variable names for
correlation analysis. Ignored when dot vars are specified. \itemize{ \item
If \code{vars} is NULL, multiple pairwise correlation tests is performed
between all variables in the data. \item If \code{vars} contain only one
variable, a pairwise correlation analysis is performed between the specified
variable vs either all the remaining numeric variables in the data or
variables in \code{vars2} (if specified). \item If \code{vars} contain two
or more variables: i) if \code{vars2} is not specified, a pairwise
correlation analysis is performed between all possible combinations of
variables. ii) if \code{vars2} is specified, each element in \code{vars} is
tested against all elements in \code{vars2}}. Accept unquoted
variable names: \code{c(var1, var2)}.}

\item{vars2}{optional character vector. If specified, each element in
\code{vars} is tested against all elements in \code{vars2}. Accept unquoted
variable names: \code{c(var1, var2)}.}

\item{alternative}{indicates the alternative hypothesis and must be
    one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.  You
    can specify just the initial letter.  \code{"greater"} corresponds
    to positive association, \code{"less"} to negative association.}

\item{method}{a character string indicating which correlation
    coefficient is to be  used for the test.  One of \code{"pearson"},
    \code{"kendall"}, or \code{"spearman"}, can be abbreviated.}

\item{conf.level}{confidence level for the returned confidence
    interval.  Currently only used for the Pearson product moment
    correlation coefficient if there are at least 4 complete pairs of
    observations.}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}
}
\value{
return a data frame with the following columns: \itemize{ \item
 \code{var1, var2}: the variables used in the correlation test. \item
 \code{cor}: the correlation coefficient. \item \code{statistic}: Test
 statistic used to compute the p-value. \item \code{p}: p-value. \item
 \code{conf.low,conf.high}: Lower and upper bounds on a confidence interval.
 \item \code{method}: the method used to compute the statistic.}
}
\description{
Provides a pipe-friendly framework to perform correlation test
 between paired samples, using Pearson, Kendall or Spearman method. Wrapper
 around the function \code{\link[stats]{cor.test}()}.

 Can also performs multiple pairwise correlation analyses between more than
 two variables or between two different vectors of variables. Using this
 function, you can also compute, for example, the correlation between one
 variable vs many.
}
\section{Functions}{
\itemize{
\item \code{cor_test}: correlation test between two or more variables.
}}

\examples{

# Correlation between the specified variable vs
# the remaining numeric variables in the data
#:::::::::::::::::::::::::::::::::::::::::
mtcars \%>\% cor_test(mpg)

# Correlation test between two variables
#:::::::::::::::::::::::::::::::::::::::::
mtcars \%>\% cor_test(wt, mpg)

# Pairwise correlation between multiple variables
#:::::::::::::::::::::::::::::::::::::::::
mtcars \%>\% cor_test(wt, mpg, disp)

# Grouped data
#:::::::::::::::::::::::::::::::::::::::::
iris \%>\%
  group_by(Species) \%>\%
 cor_test(Sepal.Width, Sepal.Length)

# Multiple correlation test
#:::::::::::::::::::::::::::::::::::::::::
# Correlation between one variable vs many
mtcars \%>\% cor_test(
  vars = "mpg",
  vars2 = c("disp", "hp", "drat")
 )

# Correlation between two vectors of variables
# Each element in vars is tested against all elements in vars2
mtcars \%>\% cor_test(
  vars = c("mpg", "wt"),
  vars2 = c("disp", "hp", "drat")
 )


}
\seealso{
\code{\link{cor_mat}()}, \code{\link{as_cor_mat}()}
}
