% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R
\name{cohens_d}
\alias{cohens_d}
\title{Compute Cohen's d Measure of Effect Size}
\usage{
cohens_d(
  data,
  formula,
  comparisons = NULL,
  ref.group = NULL,
  paired = FALSE,
  mu = 0,
  var.equal = FALSE,
  hedges.correction = FALSE,
  ci = FALSE,
  conf.level = 0.95,
  ci.type = "perc",
  nboot = 1000
)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{comparisons}{A list of length-2 vectors specifying the groups of
interest to be compared. For example to compare groups "A" vs "B" and "B" vs
"C", the argument is as follow: \code{comparisons = list(c("A", "B"), c("B",
"C"))}}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 If \code{ref.group = "all"}, pairwise two sample tests are
 performed for comparing each grouping variable levels against all (i.e.
 basemean).}

\item{paired}{a logical indicating whether you want a paired test.}

\item{mu}{theoretical mean, use for one-sample t-test. Default is 0.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal. If TRUE then the pooled variance is used to
estimate the variance otherwise the Welch (or Satterthwaite) approximation
to the degrees of freedom is used. Used only for unpaired or independent samples test.}

\item{hedges.correction}{logical indicating whether apply the Hedges
correction by multiplying the usual value of Cohen's d by
\code{(N-3)/(N-2.25)} (for unpaired t-test) and by \code{(n1-2)/(n1-1.25)} for paired t-test;
where \code{N} is the total size of the two groups being compared (N = n1 +
n2).}

\item{ci}{If TRUE, returns confidence intervals by bootstrap. May be slow.}

\item{conf.level}{The level for the confidence interval.}

\item{ci.type}{The type of confidence interval to use. Can be any of "norm",
"basic", "perc", or "bca". Passed to \code{boot::boot.ci}.}

\item{nboot}{The number of replications to use for bootstrap.}
}
\value{
return a data frame with some of the following columns: \itemize{
 \item \code{.y.}: the y variable used in the test. \item
 \code{group1,group2}: the compared groups in the pairwise tests. \item
 \code{n,n1,n2}: Sample counts. \item \code{effsize}: estimate of the effect
 size (\code{d} value). \item \code{magnitude}: magnitude of effect size.
 \item \code{conf.low,conf.high}: lower and upper bound of the effect size
 confidence interval.}
}
\description{
Compute the effect size for t-test. T-test conventional effect
 sizes, proposed by Cohen, are: 0.2 (small effect), 0.5 (moderate effect) and
 0.8 (large effect).

 Cohen's \code{d} is calculated as the difference between means or mean minus
 \code{mu} divided by the estimated standardized deviation.

 For independent samples t-test, there are two possibilities implemented. If
 the t-test did not make a homogeneity of variance assumption, (the Welch
 test), the variance term will mirror the Welch test, otherwise a pooled
 estimate is used.

 If a paired samples t-test was requested, then effect size desired is based
 on the standard deviation of the differences.

 It can also returns confidence intervals by bootstap.
}
\details{
Quantification of the effect size magnitude is performed using the
 thresholds defined in Cohen (1992). The magnitude is assessed using the
 thresholds provided in (Cohen 1992), i.e. \code{|d| < 0.2} "negligible",
 \code{|d| < 0.5} "small", \code{|d| < 0.8} "medium", otherwise "large".
}
\examples{
# One-sample t test effect size
ToothGrowth \%>\% cohens_d(len ~ 1, mu = 0)

# Two indepedent samples t-test effect size
ToothGrowth \%>\% cohens_d(len ~ supp, var.equal = TRUE)

# Paired samples effect size
df <- data.frame(
  id = 1:5,
  pre  = c(110, 122, 101, 120, 140),
  post = c(150, 160, 110, 140, 155)
)
df <- df \%>\% gather(key = "treatment", value = "value", -id)
head(df)

df \%>\% cohens_d(value ~ treatment, paired = TRUE)
}
\references{
\itemize{ \item Cohen, J. (1988). Statistical power analysis for
 the behavioral sciences (2nd ed.). New York:Academic Press. \item Cohen, J.
 (1992). A power primer. Psychological Bulletin, 112, 155-159. \item Hedges,
 Larry & Olkin, Ingram. (1985). Statistical Methods in Meta-Analysis.
 10.2307/1164953. \item Navarro, Daniel. 2015. Learning Statistics with R: A
 Tutorial for Psychology Students and Other Beginners (Version 0.5). }
}
