% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_test.R
\name{sign_test}
\alias{sign_test}
\alias{pairwise_sign_test}
\title{Sign Test}
\usage{
sign_test(data, formula, comparisons = NULL, ref.group = NULL,
  p.adjust.method = "holm", alternative = "two.sided", mu = 0,
  conf.level = 0.95, detailed = FALSE)

pairwise_sign_test(data, formula, comparisons = NULL, ref.group = NULL,
  p.adjust.method = "holm", detailed = FALSE, ...)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ treatment}.}

\item{comparisons}{A list of length-2 vectors specifying the groups of
interest to be compared. For example to compare groups "A" vs "B" and "B" vs
"C", the argument is as follow: \code{comparisons = list(c("A", "B"), c("B",
"C"))}}

\item{ref.group}{a character string specifying the reference group. If
specified, for a given grouping variable, each of the group levels will be
compared to the reference group (i.e. control group).}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{mu}{a single number representing the value of the population median
specified by the null hypothesis.}

\item{conf.level}{confidence level of the interval.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}

\item{...}{other arguments passed to the function \code{sign_test()}}
}
\value{
return a data frame with some the following columns: \itemize{ \item
 \code{.y.}: the y variable used in the test. \item \code{group1,group2}: the
 compared groups in the pairwise tests. \item \code{n,n1,n2}: Sample counts.
 \item \code{statistic}: Test statistic used to compute the p-value. That is
 the S-statistic (the number of positive differences between the data and the
 hypothesized median), with names attribute \code{"S"}. \item \code{df,
 parameter}: degrees of freedom. Here, the total number of valid differences.
 \item \code{p}: p-value.  \item \code{method}: the statistical test used to
 compare groups. \item \code{p.signif, p.adj.signif}: the significance level
 of p-values and adjusted p-values, respectively. \item \code{estimate}:
 estimate of the effect size. It corresponds to the median of the
 differences. \item \code{alternative}: a character string describing the
 alternative hypothesis. \item \code{conf.low,conf.high}: Lower and upper
 bound on a confidence interval of the estimate. }

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs one-sample and two-sample sign tests. Read more:
 \href{https://www.datanovia.com/en/lessons/sign-test-in-r/}{Sign Test in R}.
}
\section{Functions}{
\itemize{
\item \code{sign_test}: Sign test

\item \code{pairwise_sign_test}: performs pairwise two sample Wilcoxon test.
}}

\note{
This function is a reimplementation of the function \code{SignTest()}
 from the \code{DescTools} package.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth

# One-sample test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% sign_test(len ~ 1, mu = 0)


# Two-samples paired test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% sign_test(len ~ supp)


# Compare supp levels after grouping the data by "dose"
#::::::::::::::::::::::::::::::::::::::::
df \%>\%
  group_by(dose) \%>\%
  sign_test(data =., len ~ supp) \%>\%
  adjust_pvalue(method = "bonferroni") \%>\%
  add_significance("p.adj")

# pairwise comparisons
#::::::::::::::::::::::::::::::::::::::::
# As dose contains more than two levels ==>
# pairwise test is automatically performed.
df \%>\% sign_test(len ~ dose)

# Comparison against reference group
#::::::::::::::::::::::::::::::::::::::::
# each level is compared to the ref group
df \%>\% sign_test(len ~ dose, ref.group = "0.5")


}
