% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\title{Generic function for drawing from the posterior predictive distribution}
\usage{
posterior_predict(object, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods.}
}
\value{
\code{posterior_predict} methods should return a \eqn{D} by \eqn{N}
  matrix, where \eqn{D} is the number of draws from the posterior predictive
  distribution and \eqn{N} is the number of data points being predicted per
  draw.
}
\description{
See \code{posterior_predict.stanreg} in the \pkg{rstanarm} package for an
example.
}
\examples{
# Example using rstanarm package:
# posterior_predict method for 'stanreg' objects
\donttest{
if (require("rstanarm")) {
  fit <- stan_glm(mpg ~ wt + am, data = mtcars)
  yrep <- posterior_predict(fit)
  all.equal(ncol(yrep), nobs(fit))

  nd <- data.frame(wt = mean(mtcars$wt), am = c(0, 1))
  ytilde <- posterior_predict(fit, newdata = nd)
  all.equal(ncol(ytilde), nrow(nd))
}
}

# Also see help("posterior_predict", package = "rstanarm")

}
\seealso{
The \pkg{rstanarm} package for example methods
  (\url{https://CRAN.R-project.org/package=rstanarm}).

The guidelines for developers of R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}.
}

