\name{plot-methods}
\alias{plot-methods} 
% \alias{plot,ANY,ANY-method}
\alias{plot,stanfit,missing-method}
\docType{methods}

\title{\code{plot}: plot an overview of summaries for the fitted model} 
\description{Drawn an overview of parameter summaries for the fitted model.
  In the overview plot, we also indicate the values of Rhats for
  all parameters of interest using differnt colors. In addition to all the
  parameters, the log-posterior is also plotted. 
} 

\usage{
  \S4method{plot}{stanfit,missing}(x, pars, display_parallel = FALSE, 
  ask = TRUE, npars_per_page = 6, include = TRUE)
} 

\section{Methods}{
  \describe{
    \item{plot}{\code{signature(x = "stanfit", y = "missing")}}{ Plot an overview of parameter
      summaries for the fitted model.}
  }
}

\arguments{
  \item{x}{An instance of class \code{\linkS4class{stanfit}}.}
  \item{pars}{A vector of character string specifying the  
    parameters to be plotted. If not specified, all parameters
    are used. If \code{include = FALSE}, then the parameters are
    excluded from the plot.} 
  \item{display_parallel}{\code{TRUE} or \code{FALSE}, indicating 
    whether to plot the intervals with one line for each chain
    or one line for all chains. The default is \code{FALSE} so
    that only one interval line is drawn for each scalar parameter.} 
  \item{ask}{\code{TRUE} or \code{FALSE}, to control (for the current device)
    whether the user is prompted before starting a new page of output in the case
    there are a lot of parameters (see \code{\link[grDevices]{devAskNewPage}}).}
  \item{npars_per_page}{An integer to specify the number of parameters 
    that would be plotted per page.}
  \item{include}{Logical scalar indicating whether to include (the default)
    or exclude the parameters given by the \code{pars} argument from the plot.}
}
\value{\code{NULL}} 
\examples{\dontrun{
library(rstan) 
fit <- stan(model_code = "parameters {real y;} model {y ~ normal(0,1);}") 
plot(fit) 
}

# Create a stanfit object from reading CSV files of samples (saved in rstan
# package) generated by funtion stan for demonstration purpose from model as follows. 
# 
excode <- '
  transformed data {
    real y[20];
    y[1] <- 0.5796;  y[2]  <- 0.2276;   y[3] <- -0.2959; 
    y[4] <- -0.3742; y[5]  <- 0.3885;   y[6] <- -2.1585;
    y[7] <- 0.7111;  y[8]  <- 1.4424;   y[9] <- 2.5430; 
    y[10] <- 0.3746; y[11] <- 0.4773;   y[12] <- 0.1803; 
    y[13] <- 0.5215; y[14] <- -1.6044;  y[15] <- -0.6703; 
    y[16] <- 0.9459; y[17] <- -0.382;   y[18] <- 0.7619;
    y[19] <- 0.1006; y[20] <- -1.7461;
  }
  parameters {
    real mu;
    real<lower=0, upper=10> sigma;
    vector[2] z[3];
    real<lower=0> alpha;
  } 
  model {
    y ~ normal(mu, sigma);
    for (i in 1:3) 
      z[i] ~ normal(0, 1);
    alpha ~ exponential(2);
  } 
'

# exfit <- stan(model_code = excode, save_dso = FALSE, iter = 200, 
#               sample_file = "rstan_doc_ex.csv")
# 
exfit <- read_stan_csv(dir(system.file('misc', package = 'rstan'),
                       pattern='rstan_doc_ex_[[:digit:]].csv',
                       full.names = TRUE))

print(exfit)
plot(exfit) 
} 
\keyword{methods}
