% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_restrictions.R
\name{match_restrictions}
\alias{match_restrictions}
\title{Alter numeric data records to match linear (in)equality constraints.}
\usage{
match_restrictions(dat, restrictions, adjust, weight = rep(1, ncol(dat)),
  remove_tag = TRUE, ...)
}
\arguments{
\item{dat}{A \code{data.frame}}

\item{restrictions}{An object of class \code{\link[validate]{validator}}}

\item{adjust}{(optional) A \code{logical} matrix of dimensions
\code{dim(dat)} where \code{TRUE} indicates that a value may be adjusted.
When missing, the \code{\link{tagged_values}} are used. If no tagging was
applied, adjust will default to an all \code{TRUE} matrix with
dimensions equal to \code{dim(dat)}.}

\item{weight}{A weight vector of length \code{ncol(dat)} or a matrix of dimensions \code{dim(dat)}.}

\item{remove_tag}{if a value position indicator is present, remove it?}

\item{...}{arguments passed to \code{\link[lintools]{project}}.}
}
\value{
\code{dat}, with values adapted.
}
\description{
Apply the successive projection algorithm to adjust each record in 
\code{dat} to satisfy a set of linear (in)equality constraints.
}
\examples{

# a very simple adjustment example

v <- validate::validator(
	x + y == 10,
	x > 0,
	y > 0
)

# x and y will be adjusted by the same amount
match_restrictions(data.frame(x=4,y=5), v)

# One of the inequalies violated
match_restrictions(data.frame(x=-1,y=5), v)

# Weighted distances: 'heavy' variables change less
match_restrictions(data.frame(x=4,y=5), v, weight=c(100,1))

# if w=1/x0, the ratio between coefficients of x0 stay the same (to first order)
x0 <- data.frame(x=4,y=5)
x1 <- match_restrictions(x0, v, weight=1/as.matrix(x0))

x0[,1]/x0[,2]
x1[,1] / x1[2]

# example of tag usage
v <- validate::validator(x + y == 1, x>0,y>0)
d <- data.frame(x=NA,y=0.5)
d <- tag_missing(d)
# impute
d[1,1] <- 1

# only the tagged values will be altered. The tag is
# removed afterwards.
match_restrictions(d,v)


}
\seealso{
\code{\link{tag_missing}}
}
