% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-soi.R
\name{download_soi}
\alias{download_soi}
\title{Download Southern Oscillation Index data}
\usage{
download_soi(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item SOI: Southern Oscillation Index
\item SOI_3MON_AVG: 3 Month Average Southern Oscillation Index
}
}
\description{
The Southern Oscillation Index is defined as the standardized difference between barometric readings at Darwin, Australia and Tahiti.
}
\examples{
\dontrun{
soi <- download_soi()
}

}
\references{
\url{https://www.cpc.ncep.noaa.gov/data/indices/soi}
}
