% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-enso.R
\name{download_enso}
\alias{download_enso}
\title{Download Southern Oscillation Index and Oceanic Nino Index data}
\usage{
download_enso(create_csv = FALSE)
}
\arguments{
\item{create_csv}{Logical option to create a local copy of the data. Defaults to FALSE.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item dSST3.4: Monthly change in sea surface temperature at Nino region 3.4
\item ONI: Oneanic Oscillation Index
\item month_window: 3 month period over which ONI is calculated
\item phase: ENSO phase  
\item SOI: Southern Oscillation Index
\item SOI_3MON_AVG: 3 Month Average Southern Oscillation Index
}
}
\description{
The Southern Oscillation Index is defined as the standardized difference between barometric readings at Darwin, Australia and Tahiti. The Oceanic Nino Index is average sea surface temperature in the Nino 3.4 region (120W to 170W) averaged over three months. Phases are categorized by Oceanic Nino Index:
\itemize{
\item Warm phase of El Nino/ Southern Oscillation when 3-month average sea-surface temperature departure of positive 0.5 degC
\item Cool phase of La Nina/ Southern Oscillation when 3-month average sea-surface temperature departure of negative 0.5 degC
\item Neutral phase is defined as when the three month temperature average is between +0.5 and -0.5 degC
}
}
\examples{
enso <- download_enso()
plot(x = enso$Date, y = enso$SOI, type = "l")

}
\references{
\url{https://www.ncdc.noaa.gov/teleconnections/enso/indicators/soi/} and \url{http://www.cpc.ncep.noaa.gov/products/analysis_monitoring/ensostuff/detrend.nino34.ascii.txt}
}
