% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{locate_point_on_line}
\alias{locate_point_on_line}
\title{Locate a Point on a LineString}
\usage{
locate_point_on_line(x, y)
}
\arguments{
\item{x}{an object of class \code{rs_LINESTRING}}

\item{y}{an object of class \code{rs_POINT}}
}
\value{
A numeric vector containing the fraction of of the LineString that
would need to be traveled to reach the closest point.
}
\description{
Calculates the fraction of a LineString's length to a point
that is closes to a corresponding point in \code{y}.
}
\examples{
x <- geom_linestring(c(-1, 0, 0), c(0, 0, 1))
y <- geom_point(-0.5, 0)
locate_point_on_line(x, y)
}
