% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_ignore_outputs.R
\name{git_ignore_outputs}
\alias{git_ignore_outputs}
\title{Git ignore generated outputs}
\usage{
git_ignore_outputs(path = ".", figs_only = TRUE)
}
\arguments{
\item{path}{path of the directory containing the input files \code{.gitignore} and
\verb{_bookdown.yml}.}

\item{figs_only}{logical; if \code{TRUE} (default), only figures are git ignored.}
}
\description{
Add generated reports, figures, and HTML libraries to .gitignore
}
\examples{
\donttest{
wd <- tempdir()
savedir <- setwd(wd)
file.copy(list.files(system.file("extdata", package = "rsf"),
                     full.names = TRUE, all.files = TRUE, no.. = TRUE), ".")
file.rename("gitignore", ".gitignore")
git_ignore_outputs(figs_only = FALSE)
setwd(savedir)
}
}
