% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{sc_filter}
\alias{sc_filter}
\alias{sc_filter_}
\title{Filter scorecard data by variable values.}
\usage{
sc_filter(sccall, ...)

sc_filter_(sccall, filter_string)
}
\arguments{
\item{sccall}{Current list of parameters carried forward from prior
functions in the chain (ignore)}

\item{...}{Expressions to evaluate}

\item{filter_string}{Filter as character string or vector of
filters as character strings}
}
\description{
This function is used to filter the downloaded scorecard data. It
converts idiomatic R into the format required by the API call.
}
\section{Functions}{
\itemize{
\item \code{sc_filter_()}: Standard evaluation version of
\code{\link{sc_filter}} (\code{filter_string} must be a string
or vector of strings when using this version)

}}
\examples{
\dontrun{
sc_filter(region == 1) # New England institutions
sc_filter(stabbr == c("TN","KY")) # institutions in Tennessee and Kentucky
sc_filter(control != 3) # exclude private, for-profit institutions
sc_filter(control == c(1,2)) # same as above
sc_filter(control == 1:2) # same as above
sc_filter(stabbr == "TN", control == 1, locale == 41:43) # TN rural publics
}
\dontrun{
sc_filter_("region == 1")
sc_filter_("control != 3")

## With internal strings, you must either use both double and single quotes
## or escape internal quotes
sc_filter_("stabbr == c('TN','KY')")
sc_filter_('stabbr == c(\'TN\',\'KY\')')

## stored in object
filters <- c("control == 1", "locale == 41:43")
sc_filter_(filters)
}
}
