/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import scala.DeprecatedConsole;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.io.AnsiColor;
import scala.sys.package$;
import scala.util.DynamicVariable;

public final class Console$
extends DeprecatedConsole
implements AnsiColor {
    public static final Console$ MODULE$;
    private final ByteArrayOutputStream baosOut;
    private final ByteArrayOutputStream baosErr;
    private final PrintStream psOut;
    private final PrintStream psErr;
    private final PrintStream originalOut;
    private final PrintStream originalErr;
    private final DynamicVariable<PrintStream> outVar;
    private final DynamicVariable<PrintStream> errVar;
    private final DynamicVariable<BufferedReader> inVar;

    static {
        new Console$();
    }

    public final String BLACK() {
        return "\u001b[30m";
    }

    public final String RED() {
        return "\u001b[31m";
    }

    public final String GREEN() {
        return "\u001b[32m";
    }

    public final String YELLOW() {
        return "\u001b[33m";
    }

    public final String BLUE() {
        return "\u001b[34m";
    }

    public final String MAGENTA() {
        return "\u001b[35m";
    }

    public final String CYAN() {
        return "\u001b[36m";
    }

    public final String WHITE() {
        return "\u001b[37m";
    }

    public final String BLACK_B() {
        return "\u001b[40m";
    }

    public final String RED_B() {
        return "\u001b[41m";
    }

    public final String GREEN_B() {
        return "\u001b[42m";
    }

    public final String YELLOW_B() {
        return "\u001b[43m";
    }

    public final String BLUE_B() {
        return "\u001b[44m";
    }

    public final String MAGENTA_B() {
        return "\u001b[45m";
    }

    public final String CYAN_B() {
        return "\u001b[46m";
    }

    public final String WHITE_B() {
        return "\u001b[47m";
    }

    public final String RESET() {
        return "\u001b[0m";
    }

    public final String BOLD() {
        return "\u001b[1m";
    }

    public final String UNDERLINED() {
        return "\u001b[4m";
    }

    public final String BLINK() {
        return "\u001b[5m";
    }

    public final String REVERSED() {
        return "\u001b[7m";
    }

    public final String INVISIBLE() {
        return "\u001b[8m";
    }

    public ByteArrayOutputStream baosOut() {
        return this.baosOut;
    }

    public ByteArrayOutputStream baosErr() {
        return this.baosErr;
    }

    public PrintStream psOut() {
        return this.psOut;
    }

    public PrintStream psErr() {
        return this.psErr;
    }

    public PrintStream originalOut() {
        return this.originalOut;
    }

    public PrintStream originalErr() {
        return this.originalErr;
    }

    private DynamicVariable<PrintStream> outVar() {
        return this.outVar;
    }

    private DynamicVariable<PrintStream> errVar() {
        return this.errVar;
    }

    private DynamicVariable<BufferedReader> inVar() {
        return this.inVar;
    }

    @Override
    public void setOutDirect(PrintStream out) {
        this.outVar().value_$eq((Object)out);
    }

    @Override
    public void setErrDirect(PrintStream err) {
        this.errVar().value_$eq((Object)err);
    }

    @Override
    public void setInDirect(BufferedReader in) {
        this.inVar().value_$eq((Object)in);
    }

    public PrintStream out() {
        return (PrintStream)this.outVar().value();
    }

    public PrintStream err() {
        return (PrintStream)this.errVar().value();
    }

    public BufferedReader in() {
        return (BufferedReader)this.inVar().value();
    }

    public <T> T withOut(PrintStream out, Function0<T> thunk) {
        return (T)this.outVar().withValue((Object)out, thunk);
    }

    public <T> T withOut(OutputStream out, Function0<T> thunk) {
        return this.withOut(new PrintStream(out), thunk);
    }

    public <T> T withErr(PrintStream err, Function0<T> thunk) {
        return (T)this.errVar().withValue((Object)err, thunk);
    }

    public <T> T withErr(OutputStream err, Function0<T> thunk) {
        return this.withErr(new PrintStream(err), thunk);
    }

    public <T> T withIn(Reader reader, Function0<T> thunk) {
        return (T)this.inVar().withValue((Object)new BufferedReader(reader), thunk);
    }

    public <T> T withIn(InputStream in, Function0<T> thunk) {
        return this.withIn(new InputStreamReader(in), thunk);
    }

    public void print(Object obj) {
        this.out().print(obj == null ? "null" : obj.toString());
    }

    public void flush() {
        this.out().flush();
    }

    public void println() {
        this.out().println();
    }

    public void println(Object x) {
        this.out().println(x);
    }

    public void printf(String text, Seq<Object> args) {
        this.out().print(new StringOps(Predef$.MODULE$.augmentString(text)).format(args));
    }

    private Console$() {
        MODULE$ = this;
        AnsiColor.class.$init$((AnsiColor)this);
        this.baosOut = new ByteArrayOutputStream();
        this.baosErr = new ByteArrayOutputStream();
        this.psOut = new PrintStream(this.baosOut(), true);
        this.psErr = new PrintStream(this.baosErr(), true);
        this.originalOut = System.out;
        this.originalErr = System.err;
        try {
            Object object = package$.MODULE$.env().apply((Object)"RSCALA_TUNNELING");
            String string = "TRUE";
            if (!(object != null ? !object.equals(string) : string != null)) {
                System.setOut(this.psOut());
                System.setErr(this.psErr());
            }
        }
        catch (Throwable throwable) {}
        this.outVar = new DynamicVariable((Object)System.out);
        this.errVar = new DynamicVariable((Object)System.err);
        this.inVar = new DynamicVariable((Object)new BufferedReader(new InputStreamReader(System.in)));
    }
}

