% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R
\docType{class}
\name{records-class}
\alias{records-class}
\title{A class object for satellite image metadata}
\description{
This class object organizes the attributes of satellite images' metadata
from several missions/programs uniformly. Structuring the information
facilitates managing, previewing, and downloading data records.
}
\details{
\code{records} works as vector. It accepts usual R methods such as
\code{c}, \code{[]}, \code{length()}, \code{subset()} or \code{unique()}.
Each record (vector element) contains several parameters or slots.

The object can be coerced into a \code{data.frame} by
using the function \code{as.data.frame()}. The \code{data.frame} can
be transformed back into a \code{records} with the function
\code{as.records()}.
}
\section{Slots}{

\describe{
\item{\code{sat}}{the name of the satellite.}

\item{\code{name}}{the name of the file.}

\item{\code{date}}{capturing date of the image.}

\item{\code{product}}{name of the data product.}

\item{\code{path}}{the path of the tiling system.}

\item{\code{row}}{the row of the tiling system.}

\item{\code{tileid}}{the tile identification number.}

\item{\code{download}}{the download url.}

\item{\code{file_path}}{the saving directory for the satellite record.}

\item{\code{preview}}{the preview url.}

\item{\code{api_name}}{the name of the API.}

\item{\code{order}}{boolean, whether the image needs to be ordered.}

\item{\code{extent_crs}}{coordinate reference system of the preview.}
}}

\examples{
\dontrun{
library(rsat)
# create a copy of navarre
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

rcrds <- records(navarre)

modis.rcrds <- rcrds[sat_name(rcrds)\%in\%"Modis"]
ls8.rcrds <- rcrds[sat_name(rcrds)\%in\%"Landsat-8"]

class(modis.rcrds)
dates(ls8.rcrds)
modis.ls8.records <- c(ls8.rcrds, modis.rcrds)

print(modis.ls8.records)
}
}
