% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tMoveRes.R
\name{tMoveRes}
\alias{tMoveRes}
\title{tMoveRes}
\usage{
tMoveRes(xy, obs.date, time.res, pixel.res)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{obs.date}{Object of class \emph{Date} with \emph{xy} observation dates.}

\item{time.res}{Vector of temporal resolutions (expressed in days).}

\item{pixel.res}{Spatial resolution (unit depends on spatial projection).}
}
\value{
A \emph{list} object reporting on the amount and distribution of unique pixels and connected pixel regions per temporal resolution.
}
\description{
{Tool to support the selection of an adequate satellite temporal resolution. It evaluates how the change in temporal
resolution changes the amount of samples and sample regions based on a set of coordinate pairs and their observation dates.}
}
\details{
{Given a base spatial resolution (\emph{pixel.res} and a vector of temporal resolutions (\emph{time.res}), the function determines
the number of unique pixels and unique pixel regions after their temporal aggregation. For each temporal resolution, the function starts by
converting \emph{xy} to unique pixel coordinates and labels them based on their spatial aggregation. Then, the function counts the number of
samples and sample regions. The output of the function consists of:
\itemize{
 \item{\emph{stats} - Summary statistics reporting on the number of temporal widows, unique samples and unique sample regions per temporal resolution.}
 \item{\emph{plot} - Plot representing the change in number of samples and sample regions per temporal resolution.}}}
}
\examples{
{

 require(raster)

 data(longMove) # access reference data
 longMove <- longMove[c(1:50, 2000:2050,3000:3050),] # subset for testing

 # test function for intervals of 1, 8 and 16 days (e.g. of MODIS data)
 obs.date <- as.Date(longMove@data$timestamp)
 a.res <- tMoveRes(longMove, obs.date, c(1,8,16), 0.1)

}
}
\seealso{
\code{\link{sMoveRes}} \code{\link{specVar}}
}
