/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.ssh;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SshExec {
    protected Connection connection;

    public SshExec(Connection connection) throws IOException {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String cmd) throws IOException {
        Session s = null;
        try {
            s = this.connection.openSession();
            BufR std = new BufR(s.getStdout());
            BufR stderr = new BufR(s.getStderr());
            s.execCommand(cmd);
            String str = std.readCompletely();
            String err = stderr.readCompletely();
            if (err != null) {
                str = str + "\n" + err;
            }
            String string = str;
            return string;
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execNoRead(String cmd) throws IOException {
        Session s = null;
        s = this.connection.openSession();
        BufR std = new BufR(s.getStdout());
        BufR stderr = new BufR(s.getStderr());
        s.execCommand(cmd);
    }

    public void closeConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public static String exec(Connection connection, String cmd) throws IOException {
        SshExec sx = new SshExec(connection);
        return sx.exec(cmd);
    }

    public boolean fileExists(String path) throws IOException {
        String r = this.exec("[ -f " + path + "  ] && echo TRUE || echo FALSE");
        return r.trim().equals("TRUE");
    }

    class BufR {
        InputStream ins;
        InputStreamReader r;
        BufferedReader b;

        BufR(InputStream ins) {
            this.ins = ins;
            this.r = new InputStreamReader(ins);
            this.b = new BufferedReader(this.r);
        }

        String readCompletely() throws IOException {
            String l;
            StringBuilder s = new StringBuilder();
            while ((l = this.b.readLine()) != null) {
                s.append(l + "\n");
            }
            return s.toString();
        }

        void close() throws IOException {
            this.b.close();
            this.r.close();
            this.ins.close();
        }
    }
}

