% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_sp_count.R
\name{rl_sp_count}
\alias{rl_sp_count}
\alias{rl_sp_count_}
\title{Get count of species in the Red List}
\usage{
rl_sp_count(key = NULL, ...)

rl_sp_count_(key = NULL, ...)
}
\arguments{
\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{...}{Curl options passed to \link[crul:HttpClient]{HttpClient}}
}
\value{
An integer representing the number of unique species represented
within the IUCN database.
}
\description{
Returns a count of the number of unique species which have assessments.
}
\examples{
\dontrun{
# Get count of species with assessments
rl_sp_count()
}
}
\references{
API docs at \url{https://api.iucnredlist.org/}.
}
\seealso{
Red List information and statistics:
\code{\link{rl_api_version}()},
\code{\link{rl_citation}()},
\code{\link{rl_version}()}
}
\concept{stats}
