/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormatVariant;

public class RDFFormat {
    public static RDFFormatVariant PRETTY = new RDFFormatVariant("pretty");
    public static RDFFormatVariant BLOCKS = new RDFFormatVariant("blocks");
    public static RDFFormatVariant FLAT = new RDFFormatVariant("flat");
    public static RDFFormat TURTLE_PRETTY;
    public static RDFFormat TURTLE;
    public static RDFFormat TTL;
    public static RDFFormat TURTLE_BLOCKS;
    public static RDFFormat TURTLE_FLAT;
    public static RDFFormat NTRIPLES;
    public static RDFFormat NT;
    public static RDFFormat NQUADS;
    public static RDFFormat NQ;
    public static RDFFormat TRIG_PRETTY;
    public static RDFFormat TRIG;
    public static RDFFormat TRIG_BLOCKS;
    public static RDFFormat TRIG_FLAT;
    public static RDFFormatVariant ABBREV;
    public static RDFFormatVariant PLAIN;
    public static RDFFormat RDFXML_PRETTY;
    public static RDFFormat RDFXML_ABBREV;
    public static RDFFormat RDFXML;
    public static RDFFormat RDFXML_PLAIN;
    public static RDFFormat RDFJSON;
    public static RDFFormat RDFNULL;
    private final Lang lang;
    private final RDFFormatVariant variant;

    public RDFFormat(Lang lang) {
        this(lang, null);
    }

    public RDFFormat(Lang lang, RDFFormatVariant variant) {
        this.lang = lang;
        this.variant = variant;
    }

    public Lang getLang() {
        return this.lang;
    }

    public RDFFormatVariant getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFFormat other = (RDFFormat)obj;
        if (!Lib.equal(this.lang, other.lang)) {
            return false;
        }
        return Lib.equal(this.variant, other.variant);
    }

    public String toString() {
        if (this.variant == null) {
            return this.lang.getName();
        }
        return this.lang.getName() + "/" + this.variant;
    }

    static {
        TURTLE = TURTLE_PRETTY = new RDFFormat(Lang.TURTLE, PRETTY);
        TTL = TURTLE_PRETTY;
        TURTLE_BLOCKS = new RDFFormat(Lang.TURTLE, BLOCKS);
        TURTLE_FLAT = new RDFFormat(Lang.TURTLE, FLAT);
        NT = NTRIPLES = new RDFFormat(Lang.NTRIPLES);
        NQ = NQUADS = new RDFFormat(Lang.NQUADS);
        TRIG = TRIG_PRETTY = new RDFFormat(Lang.TRIG, PRETTY);
        TRIG_BLOCKS = new RDFFormat(Lang.TRIG, BLOCKS);
        TRIG_FLAT = new RDFFormat(Lang.TRIG, FLAT);
        ABBREV = new RDFFormatVariant("pretty");
        PLAIN = new RDFFormatVariant("plain");
        RDFXML_ABBREV = RDFXML_PRETTY = new RDFFormat(Lang.RDFXML, ABBREV);
        RDFXML = RDFXML_PRETTY;
        RDFXML_PLAIN = new RDFFormat(Lang.RDFXML, PLAIN);
        RDFJSON = new RDFFormat(Lang.RDFJSON);
        RDFNULL = new RDFFormat(Lang.RDFNULL);
    }
}

