/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.openjena.atlas.lib.Pool;
import org.openjena.atlas.lib.PoolBase;
import org.openjena.atlas.lib.PoolSync;

public class Chars {
    public static final char[] digits10 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] hexDigitsUC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] hexDigitsLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String encodingUTF8 = "utf-8";
    private static final String encodingASCII = "ascii";
    public static final Charset charsetUTF8 = Charset.forName("utf-8");
    public static final Charset charsetASCII = Charset.forName("ascii");
    private static final int PoolSize = 2;
    private static Pool<CharsetEncoder> encoders = PoolSync.create(new PoolBase());
    private static Pool<CharsetDecoder> decoders = PoolSync.create(new PoolBase());
    public static final int EOF = -1;
    public static final int UNSET = -2;
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final char CH_ZERO = '\u0000';
    public static final char CH_LBRACKET = '[';
    public static final char CH_RBRACKET = ']';
    public static final char CH_LBRACE = '{';
    public static final char CH_RBRACE = '}';
    public static final char CH_LPAREN = '(';
    public static final char CH_RPAREN = ')';
    public static final char CH_LT = '<';
    public static final char CH_GT = '>';
    public static final char CH_UNDERSCORE = '_';
    public static final char CH_QUOTE1 = '\'';
    public static final char CH_QUOTE2 = '\"';
    public static final char CH_EQUALS = '=';
    public static final char CH_STAR = '*';
    public static final char CH_DOT = '.';
    public static final char CH_COMMA = ',';
    public static final char CH_SEMICOLON = ';';
    public static final char CH_COLON = ':';
    public static final char CH_AMPHERSAND = '&';
    public static final char CH_AT = '@';
    public static final char CH_QMARK = '?';
    public static final char CH_HASH = '#';
    public static final char CH_PLUS = '+';
    public static final char CH_MINUS = '-';
    public static final char CH_SLASH = '/';
    public static final char CH_RSLASH = '\\';
    public static final byte B_NL = 10;
    public static final byte B_CR = 13;
    public static final byte B_LBRACKET = 91;
    public static final byte B_RBRACKET = 93;
    public static final byte B_LBRACE = 123;
    public static final byte B_RBRACE = 125;
    public static final byte B_LPAREN = 40;
    public static final byte B_RPAREN = 41;
    public static final byte B_LT = 60;
    public static final byte B_GT = 62;
    public static final byte B_UNDERSCORE = 95;
    public static final byte B_QUOTE1 = 39;
    public static final byte B_QUOTE2 = 34;
    public static final byte B_EQUALS = 61;
    public static final byte B_STAR = 42;
    public static final byte B_DOT = 46;
    public static final byte B_COMMA = 44;
    public static final byte B_SEMICOLON = 59;
    public static final byte B_COLON = 58;
    public static final byte B_AT = 64;
    public static final byte B_AMPHERSAND = 38;
    public static final byte B_QMARK = 63;
    public static final byte B_HASH = 35;
    public static final byte B_PLUS = 43;
    public static final byte B_MINUS = 45;
    public static final byte B_SLASH = 47;
    public static final byte B_RSLASH = 92;

    private Chars() {
    }

    public static CharsetEncoder createEncoder() {
        return charsetUTF8.newEncoder();
    }

    public static CharsetDecoder createDecoder() {
        return charsetUTF8.newDecoder();
    }

    public static CharsetEncoder getEncoder() {
        return encoders.get();
    }

    public static void putEncoder(CharsetEncoder encoder) {
        encoders.put(encoder);
    }

    public static CharsetDecoder getDecoder() {
        return decoders.get();
    }

    public static void putDecoder(CharsetDecoder decoder) {
        decoders.put(decoder);
    }

    public static void encodeAsHex(StringBuilder buff, char marker, char ch) {
        buff.append(marker);
        int lo = ch & 0xF;
        int hi = ch >> 4 & 0xF;
        buff.append(hexDigitsUC[hi]);
        buff.append(hexDigitsUC[lo]);
    }

    static {
        for (int i = 0; i < 2; ++i) {
            Chars.putEncoder(Chars.createEncoder());
            Chars.putDecoder(Chars.createDecoder());
        }
    }
}

