/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.json.JsonBoolean;
import org.openjena.atlas.json.JsonNumber;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.JsonVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonObject
extends JsonValue {
    private final Map<String, JsonValue> map = new HashMap<String, JsonValue>();

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject getAsObject() {
        return this;
    }

    @Override
    public void visit(JsonVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof JsonObject)) {
            return false;
        }
        return ((Object)this.map).equals(((JsonObject)other).map);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean hasKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.map.entrySet();
    }

    public JsonValue get(String key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public JsonValue put(String key, JsonValue value) {
        return this.map.put(key, value);
    }

    public JsonValue put(String key, String value) {
        return this.map.put(key, new JsonString(value));
    }

    public JsonValue put(String key, long value) {
        return this.map.put(key, JsonNumber.value(value));
    }

    public JsonValue put(String key, boolean b) {
        return this.map.put(key, new JsonBoolean(b));
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        this.map.putAll(m);
    }

    public JsonValue remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<JsonValue> values() {
        return this.map.values();
    }
}

