/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNodeRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import org.openjena.atlas.io.IndentedWriter;

public class Q_PatternLiteral
extends ExprNodeRDQL
implements ExprRDQL {
    String patternString = null;
    String modifiers = "";
    int mask;

    Q_PatternLiteral(int id) {
        super(id);
    }

    Q_PatternLiteral(RDQLParser p, int id) {
        super(p, id);
    }

    public void setPattern(String str2) {
        this.patternString = str2;
    }

    public void setModifiers(String str2) {
        this.modifiers = this.modifiers + str2;
        block5: for (int i = 0; i < this.modifiers.length(); ++i) {
            switch (this.modifiers.charAt(i)) {
                case 'i': {
                    this.mask |= 2;
                    this.mask |= 0x40;
                    continue block5;
                }
                case 'm': {
                    this.mask |= 8;
                    continue block5;
                }
                case 's': {
                    this.mask |= 0x20;
                }
            }
        }
    }

    public String toString() {
        if (this.patternString.indexOf(47) == -1) {
            return "/" + this.patternString + "/" + this.modifiers;
        }
        if (this.patternString.indexOf(33) == -1) {
            return "m!" + this.patternString + "!" + this.modifiers;
        }
        if (this.patternString.indexOf(37) == -1) {
            return "m%" + this.patternString + "%" + this.modifiers;
        }
        char marker = '!';
        return "m" + marker + this.quote(this.patternString, marker) + marker + this.modifiers;
    }

    private String quote(String pString, char marker) {
        int j;
        int i = 0;
        while ((j = pString.indexOf(marker, i)) != -1) {
            pString = pString.substring(0, j) + "\\" + pString.substring(j);
            i = j + 2;
        }
        return pString;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.toString();
    }

    public void format(IndentedWriter w) {
        w.print(this.toString());
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env) {
        throw new ARQInternalErrorException("Q_PatternLiteral.eval called!");
    }

    public String asPrefixString() {
        return this.toString();
    }

    public String asInfixString() {
        return this.toString();
    }
}

