/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.SingleByteAttrValueWriter;
import com.ctc.wstx.io.SingleByteTextWriter;
import com.ctc.wstx.io.UTFAttrValueWriter;
import com.ctc.wstx.io.UTFTextWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class TextEscaper {
    private TextEscaper() {
    }

    public static Writer constructAttrValueWriter(Writer w, String enc, char qchar) throws UnsupportedEncodingException {
        int bitSize = TextEscaper.guessEncodingBitSize(enc);
        if (bitSize < 16) {
            return new SingleByteAttrValueWriter(w, enc, qchar, 1 << bitSize);
        }
        return new UTFAttrValueWriter(w, enc, qchar, true);
    }

    public static Writer constructTextWriter(Writer w, String enc) throws UnsupportedEncodingException {
        int bitSize = TextEscaper.guessEncodingBitSize(enc);
        if (bitSize < 16) {
            return new SingleByteTextWriter(w, enc, 1 << bitSize);
        }
        return new UTFTextWriter(w, enc, true);
    }

    public static void writeEscapedXMLText(Writer w, String text) throws IOException {
        int len = text.length();
        if (len < 2) {
            if (len == 1) {
                char c = text.charAt(0);
                if (c == '<') {
                    w.write("&lt;");
                } else if (c == '&') {
                    w.write("&amp;");
                } else {
                    w.write(text.charAt(0));
                }
            }
            return;
        }
        for (int i = 0; i < len; ++i) {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = text.charAt(i)) != '<' && c != '&' && (c != '>' || i < 2 || text.charAt(i - 1) != ']' || text.charAt(i - 2) != ']')) {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(text, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            w.write("&gt;");
        }
    }

    public static void writeEscapedAttrValue(Writer w, String value) throws IOException {
        int i = 0;
        int len = value.length();
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = value.charAt(i)) != '<' && c != '&' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(value, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&quot;");
        } while (++i < len);
    }

    public static void outputDTDText(Writer w, char[] ch, int offset, int len) throws IOException {
        int i = offset;
        len += offset;
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = ch[i]) != '&' && c != '%' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(ch, start, outLen);
            }
            if (i >= len) continue;
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c == '%') {
                w.write("&#37;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&#34;");
        } while (++i < len);
    }

    public static int guessEncodingBitSize(String enc) {
        if (enc.length() < 1) {
            return 16;
        }
        if ((enc = CharsetNames.normalize(enc)) == "UTF-8") {
            return 16;
        }
        if (enc == "ISO-8859-1") {
            return 8;
        }
        if (enc == "US-ASCII") {
            return 7;
        }
        if (enc == "UTF-16" || enc == "UTF-16BE" || enc == "UTF-16LE" || enc == "UTF-32BE" || enc == "UTF-32LE") {
            return 16;
        }
        return 8;
    }
}

