/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class StringMatrix {
    private Map<Integer, Map<Integer, String>> matrix;
    private int cols = 0;
    private int rows = 0;
    private Map<Integer, String> rowHeaders;
    private Map<Integer, String> colHeaders;

    private void checkDimensions(int row, int col) {
        this.checkRows(row);
        this.checkCols(col);
    }

    private void checkRows(int row) {
        if (row < 0 || row > this.rows) {
            throw new ArrayIndexOutOfBoundsException("Incorrect row number: " + row);
        }
    }

    private void checkCols(int col) {
        if (col < 0 || col > this.cols) {
            throw new ArrayIndexOutOfBoundsException("Incorrect column number: " + col);
        }
    }

    public String get(int row, int col) {
        this.checkDimensions(row, col);
        if (this.matrix == null) {
            return "";
        }
        Map<Integer, String> matrixRow = this.matrix.get(row);
        if (matrixRow == null) {
            return "";
        }
        return matrixRow.get(col);
    }

    public String get(int row, String col) {
        this.checkRows(row);
        return this.get(row, this.getColumnNumber(col));
    }

    public int getColumnCount() {
        return this.cols;
    }

    public boolean hasColumn(String col) {
        if (this.colHeaders == null) {
            return false;
        }
        return this.colHeaders.containsValue(col);
    }

    public int getColumnNumber(String col) {
        if (this.colHeaders != null) {
            for (Integer colIndex : this.colHeaders.keySet()) {
                String colname = this.colHeaders.get(colIndex);
                if (colname == null || !colname.equals(col)) continue;
                return colIndex;
            }
        }
        throw new IllegalAccessError("No column found with this label.");
    }

    public String getColumnName(int index) {
        this.checkCols(index);
        if (this.colHeaders == null) {
            return "";
        }
        return this.colHeaders.get(index);
    }

    public int getRowCount() {
        return this.rows;
    }

    public String getRowName(int index) {
        this.checkRows(index);
        if (this.rowHeaders == null) {
            return "";
        }
        return this.rowHeaders.get(index);
    }

    public boolean hasColHeader() {
        return this.colHeaders != null;
    }

    public boolean hasRowHeader() {
        return this.rowHeaders != null;
    }

    public void set(int row, int col, String value) {
        Map<Integer, String> matrixRow;
        if (row > this.rows) {
            this.rows = row;
        }
        if (col > this.cols) {
            this.cols = col;
        }
        this.checkDimensions(row, col);
        if (this.matrix == null) {
            this.matrix = new Hashtable<Integer, Map<Integer, String>>(row);
        }
        if ((matrixRow = this.matrix.get(row)) == null) {
            matrixRow = new Hashtable<Integer, String>(col);
            this.matrix.put(row, matrixRow);
        }
        matrixRow.put(col, value);
    }

    public void setColumnName(int index, String name) {
        if (index > this.cols) {
            this.cols = index;
        }
        this.checkCols(index);
        if (this.colHeaders == null) {
            this.colHeaders = new Hashtable<Integer, String>();
        }
        this.colHeaders.put(index, name);
    }

    public void setRowName(int index, String name) {
        this.checkRows(index);
        if (this.rowHeaders == null) {
            this.rowHeaders = new Hashtable<Integer, String>();
        }
        this.rowHeaders.put(index, name);
    }

    public void setSize(int row, int col) {
        this.rows = row;
        this.cols = col;
    }

    public void set(int row, String col, String value) {
        this.checkRows(row);
        this.set(row, this.getColumnNumber(col), value);
    }

    public List<String> getColumn(int col) {
        this.checkCols(col);
        int rowCount = this.getRowCount();
        ArrayList<String> results = new ArrayList<String>(rowCount);
        int i = 1;
        while (i <= rowCount) {
            String result = this.get(i, col);
            results.add(result == null ? "" : result);
            ++i;
        }
        return results;
    }

    public List<String> getColumn(String col) {
        int colNo = this.getColumnNumber(col);
        return this.getColumn(colNo);
    }

    public String toString() {
        String result;
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        if (this.hasColHeader()) {
            buffer.append("[");
            int col = 1;
            while (col <= this.getColumnCount()) {
                buffer.append('\"');
                result = this.getColumnName(col);
                buffer.append(result == null ? "" : result);
                buffer.append('\"');
                if (col < this.getColumnCount()) {
                    buffer.append(',');
                }
                ++col;
            }
            buffer.append("],\n");
        }
        int row = 1;
        while (row <= this.getRowCount()) {
            if (this.hasRowHeader()) {
                buffer.append('\"');
                result = this.getRowName(row);
                buffer.append(result == null ? "" : result);
                buffer.append("\": ");
            }
            buffer.append('[');
            int col = 1;
            while (col <= this.getColumnCount()) {
                buffer.append('\"');
                String result2 = this.get(row, col);
                buffer.append(result2 == null ? "" : result2);
                buffer.append('\"');
                if (col < this.getColumnCount()) {
                    buffer.append(',');
                }
                ++col;
            }
            buffer.append(']');
            if (row < this.getRowCount()) {
                buffer.append(',');
            }
            buffer.append('\n');
            ++row;
        }
        buffer.append(']');
        buffer.append('\n');
        return buffer.toString();
    }

    public List<String> getColumnNames() {
        ArrayList<String> names = new ArrayList<String>(this.getColumnCount());
        int i = 1;
        while (i <= this.getColumnCount()) {
            names.add(this.getColumnName(i));
            ++i;
        }
        return names;
    }

    public List<String> getRowNames() {
        ArrayList<String> names = new ArrayList<String>(this.getRowCount());
        int i = 1;
        while (i <= this.getRowCount()) {
            names.add(this.getRowName(i));
            ++i;
        }
        return names;
    }
}

