% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{rrda.fit}
\alias{rrda.fit}
\title{Calculate the coefficient Bhat by Ridge Redundancy Analysis.}
\usage{
rrda.fit(
  Y,
  X,
  nrank = NULL,
  lambda = 1,
  component = TRUE,
  center.X = TRUE,
  center.Y = TRUE,
  scale.X = FALSE,
  scale.Y = FALSE
)
}
\arguments{
\item{Y}{A numeric matrix of response variables.}

\item{X}{A numeric matrix of explanatory variables.}

\item{nrank}{A numeric vector specifying the ranks of Bhat. Default is \code{NULL}, which sets it to \code{(1:min(15, min(dim(X), dim(Y))))}.}

\item{lambda}{A numeric vector of ridge penalty values. Default value is 1.}

\item{component}{Logical indicating if Bhat is returned as vectors or matrices. If \code{TRUE}, returns Bhat as component vectors. If \code{FALSE}, returns Bhat as matrices.}

\item{center.X}{Logical indicating if \code{X} should be centered. If \code{TRUE}, scales \code{X}. Default is \code{TRUE}.}

\item{center.Y}{Logical indicating if \code{Y} should be centered. If \code{TRUE}, scales \code{Y}. Default is \code{TRUE}.}

\item{scale.X}{Logical indicating if \code{X} should be scaled. If \code{TRUE}, scales \code{X}. Default is \code{FALSE}.}

\item{scale.Y}{Logical indicating if \code{Y} should be scaled. If \code{TRUE}, scales \code{Y}. Default is \code{FALSE}.}
}
\value{
A list containing Bhat components or Bhat matrices (the coefficient of Ridge Redundancy Analysis for each parameter lambda and nrank), ranks, and lambda values.
}
\description{
This function performs Ridge Redundancy Analysis (RRDA) to obtain the coefficient Bhat, which models the relationship between a matrix of response variables (Y; \eqn{n \times q} matrix) and a matrix of explanatory variables (X; \eqn{n \times p} matrix). Especially, the function is designed to facilitate a high-dimensional computation and storing (for the details, refer to the article Yoshioka et al. 2025).

The Ridge Redundancy Analysis model is represented as:
\deqn{Y = XB + E}
where:
\itemize{
\item \eqn{Y} is the response matrix (\eqn{n \times q}),
\item \eqn{X} is the predictor matrix (\eqn{n \times p}),
\item \eqn{B} is the regression coefficient matrix (\eqn{p \times q}), and
\item \eqn{E} is the error matrix (\eqn{n \times q}).
}

The regularized estimate of \eqn{B} is described as:
\deqn{\hat{B}(\lambda) = \left(X'X + \lambda P_{X'}\right)^{-} X'Y}

Additionally, the regularized-rank-restricted estimation of \eqn{B} is represented as:
\deqn{\hat{B}(\lambda, r) = U_{\hat{B}(\lambda)}^{[r]} D_{\hat{B}(\lambda)}^{[r]} V_{\hat{B}(\lambda)}^{[r]'}}
Here:
\itemize{
\item \eqn{U_{\hat{B}(\lambda)}^{[r]}} is a \eqn{p \times r} matrix,
\item \eqn{D_{\hat{B}(\lambda)}^{[r]}} is a \eqn{r \times r} diagonal matrix, and
\item \eqn{V_{\hat{B}(\lambda)}^{[r]}} is a \eqn{q \times r} matrix.
}

The user can specify ranks (nrank), ridge penalty values (lambda), and whether to center and scale the X and Y matrices.

The Bhat can be returned as either component vectors or matrices. To store a large size of matrix, the coefficient Bhat is by default stored as LeftBhatlambda_k (F; \eqn{p \times r} matrix) and RightBhatlambda_k (G; \eqn{q \times r}). Here, r is the specified rank (nrank) in the Ridge Redundancy Analysis formula.

For \eqn{i = 1, \ldots, r}, the matrices \eqn{F} and \eqn{G} are defined as:
\deqn{F_{.i} = U_{\hat{B}(\lambda)}^{[i]}D_{\hat{B}(\lambda)}^{[i]}, \quad G_{.i} = V_{\hat{B}(\lambda)}^{[i]}}

These definitions allow the decomposition of \eqn{\hat{B}(\lambda)} into rank-specific components, facilitating the storing of the high-dimensional regression coefficients. To reconstruct the matrix form of Bhat, you can use the \code{rrda.coef} function.
}
\examples{
set.seed(10)
simdata<-rdasim1(n = 100,p = 200,q = 200,k = 5)
X <- simdata$X
Y <- simdata$Y

# Sequential
Bhat <- rrda.fit(Y = Y, X = X, nrank = c(1:10))
names(Bhat)
}
