% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtx-utils.R
\name{orth}
\alias{orth}
\title{Orthonormal basis for the column space of matrix}
\usage{
orth(A)
}
\arguments{
\item{A}{A numeric matrix.}
}
\value{
B orthonormal basis for the column space of \code{A}.
}
\description{
Computes orthonormal basis for the column space of matrix (range space, image of a matrix)
}
\examples{
 hilbert <- function(n) { i <- seq_len(n); 1/outer(i - 1L, i, "+") }
 H12 <- hilbert(12)
 rankMM(H12)             # -> 11 - numerically more realistic
 rankMM(H12, tol=0)      # -> 12
 B <- orth(H12)

 t(B) \%*\% B
 ## pracma::subspace(H12, B)

}
