% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qineq.R
\name{qineq}
\alias{qineq}
\title{qineq}
\usage{
qineq(
  x,
  y = NULL,
  J = 100,
  measure = "QRI",
  alternative = c("two.sided", "less", "greater"),
  quantile.type = 8,
  var.method = "qor",
  conf.level = 0.95,
  true.ineq = 0.5
)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{y}{an optional second vector of data values for two-sample testing.}

\item{J}{number of grid points}

\item{measure}{quantile based inequality measure to be used.  Either "QRI" (default) or "G2".(See details).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{quantile.type}{argument for the quantile function.  Default is set to 8 so that output is consistent with default quantile function use and other functions such as IQR (see help file for \code{quantile()}
for more details)}

\item{var.method}{approach use to estimate the quantile density function.  Either "qor"(default) or "density".(See details).}

\item{conf.level}{coverage for the estimated confidence interval.}

\item{true.ineq}{the specified hypothesized value of the inequality measure or the difference of the inequality depending on whether it was a one-sample test or a two-sample test.}
}
\value{
hypothesis test results and associated confidence interval (a list with class "htest")
}
\description{
carry out hypothesis tests and obtain associated confidence intervals for quantile based inequality measures
}
\details{
This function performs hypothesis testing and calculates the corresponding confidence intervals for inequality measures based on quantiles.
The available options for quantile based measures in argument \code{measure} are shown below.
\itemize{
\item \code{QRI}: Quantile Ratio Index (Prendergast & Staudte, 2018). This is the default choice.
\item \code{G2}:  Quantile variant of the Gini index (Prendergast & Staudte, 2016a).
}

The default \code{var.method="qor"} is to estimate the probability density function directly using the lognormal Quantile Optimality Ratio (QOR)
for choosing a suitable bandwidth (Prendergast & Staudte,2016b). Alternatively, the variances can be
estimated by inverting a density estimator evaluated at the quantiles and this can be done using \code{var.method = "density"}.

For more information and further examples, see Prendergast, Dedduwakumara & Staudte (2024)
}
\examples{
# Create some data
x <- c(8.43,7.08,8.79,8.88,7.87,5.94,8.79,5.46,8.11,7.08)
y <- c(13.44,13.65,14.77,9.51,14.07,10.92,11.59,13.42,8.93,10.88)

# Two sample hypothesis test for the QRI measure
qineq(x,y)
}
\references{
Prendergast, L.A., & Staudte, R.G. (2016a). Quantile versions of the Lorenz curve. Electronic Journal of
Statistics, 10(2), 1896 – 1926.

Prendergast, L. A., & Staudte, R. G. (2016b). Exploiting the quantile optimality ratio in finding confidence intervals for quantiles. Stat, 5(1), 70-81

Prendergast, L. A., & Staudte, R. G. (2018). A simple and effective inequality measure. The American Statistician, 72(4), 328-343.

Prendergast, L. A., Dedduwakumara, D.S. & Staudte, R.G. (2024) rquest: An R package for hypothesis tests and confidence intervals
for quantiles and summary measures based on quantiles, preprint, pages 1-13
}
