% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{local_td}
\alias{local_td}
\title{Construct a table description of a local data.frame.}
\usage{
local_td(
  d,
  ...,
  name = NULL,
  name_source = wrapr::mk_tmp_name_source("rqltd"),
  env = parent.frame()
)
}
\arguments{
\item{d}{data.frame or name of data.frame to use as a data source.}

\item{...}{not used, force later arguments to be optional.}

\item{name}{if not null name to user for table.}

\item{name_source}{temporary name source.}

\item{env}{environment to work in.}
}
\value{
a relop representation of the data
}
\description{
Construct a table description of a local data.frame.
}
\examples{

d <- data.frame(x = 1)
local_td(d)
local_td("d")
local_td(as.name("d"))
local_td(data.frame(x = 1))
d \%.>\% local_td # needs wrapr 1.5.0 or newer to capture name

}
\seealso{
\code{\link{db_td}}, \code{\link{mk_td}}
}
