% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else_block.R
\name{if_else_block}
\alias{if_else_block}
\title{Simulate a per-row block-\code{if(){}else{}}.}
\usage{
if_else_block(testexpr, thenexprs = NULL, elseexprs = NULL)
}
\arguments{
\item{testexpr}{character containing the test expression.}

\item{thenexprs}{named character then assignments (altering columns, not creating).}

\item{elseexprs}{named character else assignments (altering columns, not creating).}
}
\description{
This device uses expression-\code{ifelse(,,)} to simulate the
more powerful per-row block-\code{if(){}else{}}.  The difference is
expression-\code{ifelse(,,)} can choose per-row what value to express,
whereas block-\code{if(){}else{}} can choose per-row where to assign multiple
values. By simulation we mean: a sequence of quoted mutate expressions
are emitted that implement the transform.  These expressions can then
be optimized into a minimal number of no-dependency
blocks by \code{\link{extend_se}} for efficient execution.
The idea is the user can write legible code in this notation, and
the translation turns it into safe and efficient code suitable for
execution either on \code{data.frame}s or at a big data scale using
\code{RPostgreSQL} or \code{sparklyr}.
}
\details{
Note: \code{ifebtest_*}
is a reserved column name for this procedure.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  # Example: clear one of a or b in any row where both are set.
  # Land random selections early to avoid SQLite bug.
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(
    my_db,
    'd',
    data.frame(i = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
               a = c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1),
               b = c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1),
               r = runif(10),
               edited = 0),
    temporary=TRUE, overwrite=TRUE)

  program <- if_else_block(
    testexpr = qe((a+b)>1),
    thenexprs = c(
      if_else_block(
        testexpr = qe(r >= 0.5),
        thenexprs = qae(a := 0),
        elseexprs = qae(b := 0)),
      qae(edited := 1)))
  print(program)

  trf <- extend_se(d, program)
  cat(format(trf))

  sql <- to_sql(trf, my_db)
  cat(sql)

  print(DBI::dbGetQuery(my_db, sql))

  # Why we need to land the random selection early
  # for SQLIte:
  q <- "SELECT r AS r1, r AS r2 FROM (
          SELECT random() AS r FROM (
             SELECT * from ( VALUES(1),(2) )
          ) a
       ) b"
  print(DBI::dbGetQuery(my_db, q))

  DBI::dbDisconnect(my_db)
}

}
