% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi_ops.R
\name{dbi_connection_tests}
\alias{dbi_connection_tests}
\title{Try and test database for some option settings.}
\usage{
dbi_connection_tests(db)
}
\arguments{
\item{db}{DBI database connection}
}
\value{
named list of options
}
\description{
These settings are estimated by experiments.  This is not
the full set of options- but just the ones tested here.
}
\examples{

if(requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(dbi_connection_name(my_db))
  print(dbi_connection_tests(my_db))
  # print(options(dbi_connection_tests(my_db)))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{dbi_connection_preferences}}
}
