% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_choose.R
\name{choose-file}
\alias{choose-file}
\alias{choose_fileopen}
\alias{choose_filesave}
\alias{choose_directory}
\title{Choose file or directory to open via \code{'Python'}}
\usage{
choose_fileopen(
  initialfile = NULL,
  multiple = FALSE,
  title = ifelse(multiple, "Choose Files", "Choose a File"),
  message = "",
  verbose = FALSE,
  force = FALSE
)

choose_filesave()

choose_directory(
  initialdir = NULL,
  title = "Choose a Directory",
  message = "",
  verbose = FALSE
)
}
\arguments{
\item{initialfile, initialdir}{initial selection of file or directory}

\item{multiple}{whether to open multiple files}

\item{title, message}{dialogue title and message}

\item{verbose}{whether to verbose debug information}

\item{force}{whether to force using \code{'Python'} when native \code{R}
functions are available, default is false}
}
\value{
User-selected paths. If the users select nothing, then \code{NULL}
will be returned. For multiple file selection, multiple paths will
be returned.
}
\description{
Choose a directory, one or multiple files to open, or choose a file to save.
}
\details{
Base-R has \code{\link{file.choose}} function to choose files. However,
users cannot select multiple files nor directories. These functions fill
the gap by using \code{'Python'} \code{'tkinter'} package. Please make
sure that one-time setup function \code{\link{configure_conda}} has executed
before running these functions.

The functions must run as interactive mode. If you run the functions on a
server, most likely you will get nothing. The functions themselves do not
check if you are running under interactive sessions. You must check by
yourself.
}
\examples{

if(interactive()) {
  choose_fileopen(multiple = TRUE)
}



}
