% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/load.R
\name{read_eprime}
\alias{read_eprime}
\title{Read in a text file generated by Eprime}
\usage{
read_eprime(filename, remove_clock = TRUE)
}
\arguments{
\item{filename}{Either the full or relative path to an Eprime .txt file}

\item{remove_clock}{Whether to exclude the Clock.Information XML entries.
Enabled by default.}
}
\value{
Each line of the file is stored and returned in a character vector.
}
\description{
Read in a text file generated by Eprime
}
\details{
The encoding on an Eprime txt file should be UCS-2 Little Endian,
  but sometimes this is not the case. We delegate the fussy encoding details
  to the \code{stringi::str_read_lines} function.

  If the file is not an Eprime txt--that is, if it is missing the lines
  \code{*** Header Start ***} and \code{*** Header End ***}--a warning is
  raised and the lines of text are replaced by a dummy header.
}

