% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{test_homogeneity}
\alias{test_homogeneity}
\title{Inspects disease incidence for its compatibility with a homogeneous Poisson process.}
\usage{
test_homogeneity(entry, year_start = "01-01", truncate_start = FALSE,
  truncate_end = FALSE, population_size = NULL, df = 4,
  proportion = 1e+05, level = 0.95, precision = 2)
}
\arguments{
\item{entry}{Vector of diagnosis dates for each patient in the registry in
the format YYYY-MM-DD.}

\item{year_start}{Date which to use to delimit years in the format MM-DD.
See details for how this is used.}

\item{truncate_start}{See details.}

\item{truncate_end}{See details.}

\item{population_size}{The population of the area covered by the registry. If not provided
then only absolute incidence can be calculated.}

\item{df}{The desired degrees of freedom of the smooth.}

\item{proportion}{The denominator of the incidence rate.}

\item{level}{The desired confidence interval width.}

\item{precision}{The number of decimal places required.}
}
\value{
An S3 object of class \code{incidence} with the following attributes:
  \item{yearly_incidence}{Vector of absolute incidence values for each included
  year of the registry}
  \item{ordered_diagnoses}{Vector of times (days) between diagnosis date and
  the earliest date of inclusion in the registry, ordered shortest to
  longest.}
  \item{smooth}{Smooth fitted to the cumulative incidence data.}
  \item{index_dates}{Dates delimiting the years in which incidence is
  calculated.}
  \item{mean}{List containing absolute yearly incidence as well as relative
  rates.}
  \item{pvals}{p-values resulting to a test of over and under dispersion on the
  incidence data respectively. Used to test the suitability of the homogeneous
  Poission process assumption.}
  \item{dof}{Degrees of freedom of the smooth.}
}
\description{
Calculates incidence by year of the registry data, along with mean incidence
with confidence intervals. A smoothed cumulative incidence function is fit to
the data for inspecting deviations in the registry data from a homogeneous
Poisson process.
}
\details{
Annual incidence rates are calculated for every year that is present in
\code{entry}, with years being delimited by the date specified in \code{year_start}
that include every incident case.
For example, under the default values, if the earliest incident date in \code{entry}
is 1981-04-28, and the latest is 2016-12-16, then annual incidence rates will be
calculated with the boundaries [1981-01-01, 1982-01-01), ..., [2016-01-01, 2017-01-01).

If \code{year_start} was specified as '09-01' then the boundaries would be
[1980-09-01, 1981-09-01), ..., [2016-09-01, 2017-09-01).

The \code{truncate_start} and \code{truncate_end} arguments remove incident
cases in the first and last years before and after the yearly boundaries
respectively.

So if they were both \code{TRUE}, with \code{year_start} as '09-01' as before, then the
boundaries would be [1981-09-01, 1982-09-01), ..., [2015-09-01, 2016-09-01),
i.e. the incident cases in [1981-04-28, 1981-09-01) are discarded by \code{truncate_start}
and those in [2016-09-01, 2016-12-16] removed by \code{truncate_end}.

This helps to ensure that annual incidence is measured on a time-scale appropriate
for your registry.
}
\examples{
data(prevsim)

\dontrun{
test_homogeneity(prevsim$entrydate)
}

}
