% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbComment}
\alias{dbComment}
\title{Comment table/view/schema.}
\usage{
dbComment(conn, name, comment, type = c("table", "view", "schema"),
  display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table, view
or schema name.}

\item{comment}{A character string specifying the comment.}

\item{type}{The type of the object to comment, either \code{"table"}, \code{"view"},
or \code{"schema"}}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if the comment was successfully applied.
}
\description{
Comment on a table, a view or a schema.
}
\examples{
## examples use a dummy connection from DBI package
conn<-DBI::ANSI()
dbComment(conn, name = c("schema", "table"), comment = "Comment on a view.",
    type = "view", exec = FALSE)
dbComment(conn, name = "test_schema", comment = "Comment on a schema.", type = "schema",
    exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-comment.html}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
