% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetRast.R
\name{pgGetRast}
\alias{pgGetRast}
\title{Load raster from PostGIS database.}
\usage{
pgGetRast(conn, name, rast = "rast", band = 1, digits = 9,
  boundary = NULL)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema and
table/view name holding the geometry (e.g., \code{name =
c("schema","table")})}

\item{rast}{Name of the column in \code{name} holding the raster object}

\item{band}{Index number for the band to retrieve (defaults to 1)}

\item{digits}{numeric, precision for detecting whether points are
on a regular grid (a low number of digits is a low precision)
- From \code{\link[raster]{rasterFromXYZ}} function (\code{raster} package)}

\item{boundary}{\code{sp} object or numeric. A Spatial* object,
whose bounding box will be used to select the part of the
raster to import. Alternatively, four numbers
(e.g. \code{c([top], [bottom], [right], [left])}) indicating the
projection-specific limits with which to clip the raster. \code{boundary = NULL}
(default) will return the full raster.}
}
\value{
RasterLayer
}
\description{
Retrieve rasters from a PostGIS table.
}
\examples{
\dontrun{
pgGetRast(conn, c("schema", "tablename"))
pgGetRast(conn, c("schema", "DEM"), digits = 9, boundary = c(55,
    50, 17, 12))
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}
}

