% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfun_rpm_18_04_20.R
\name{node_plot}
\alias{node_plot}
\alias{rpms::node_plot}
\title{node_plot}
\usage{
node_plot(t1, node, data, variable = NA, ...)
}
\arguments{
\item{t1}{\code{rpms} object}

\item{node}{integer label of the desired end-node.}

\item{data}{data.frame that includes variables used in rp_equ, e_equ, 
and design information}

\item{variable}{string name of variable in data to use as x-axis in plot}

\item{...}{further arguments passed to plot function.}
}
\description{
plots end-node of object of class \code{rpms}
}
\examples{
{

# model mean of retirement account value for households with reported 
# retirment account values > 0 using a binary tree while accounting for 
# clusterd data and sample weights.

s1<- which(CE$IRAX > 0)
r1 <-rpms(IRAX~EDUCA+AGE+BLS_URBN, data = CE[s1,],  weights=~FINLWT21, clusters=~CID) 

# plot node 6 if it is an end-node of the tree
if(6 \%in\% end_nodes(r1))
  node_plot(t1=r1, node=6, data=CE[s1,])

# plot node 6 if it is an end-node of the tree
if(8 \%in\% end_nodes(r1))
  node_plot(t1=r1, node=8, data=CE[s1,])

}

}
