% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtree.R
\name{qtree}
\alias{qtree}
\alias{rpms::qtree}
\title{qtree}
\usage{
qtree(t1, title = "rpms", digits = 2)
}
\arguments{
\item{t1}{rpms object created by rpms function}

\item{title}{text for the top node of the tree}

\item{digits}{integer number of displayed digits}
}
\description{
Code to write a latex qtree plot
takes a rpm frame and returns latex code to produce qtree
uses linearize as a guide
Produces text code to produce tree structure in tex document
Requires using LaTex packages and the following commands in preamble of 
LaTex doc: 
usepackage{lscape}
}
\examples{
{
# get rpms model of mean retirement contribution by several factors
r1 <-rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data=CE,
     e_equ=FINDRETX~FINCBTAX, clusters=~CID) 

# get Latex code
qtree(r1)

}
}

