% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutines.R
\name{viscosity_h2o}
\alias{viscosity_h2o}
\title{Viscosity of water}
\usage{
viscosity_h2o(tc, p)
}
\arguments{
\item{tc}{numeric, air temperature (tc), degrees C}

\item{p}{numeric, atmospheric pressure (p), Pa}
}
\value{
numeric, viscosity of water (mu), Pa s
}
\description{
Calculates the viscosity of water as a function of temperature and atmospheric
pressure.
}
\examples{
print("Density of water at 20 degrees C and standard atmospheric pressure:")
print(density_h2o(20, 101325))

}
\references{
Huber, M. L., R. A. Perkins, A. Laesecke, D. G. Friend, J. V.
Sengers, M. J. Assael, ..., K. Miyagawa (2009) New
international formulation for the viscosity of H2O, J. Phys.
Chem. Ref. Data, Vol. 38(2), pp. 101-125.
}
