% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fulltext.R
\name{plos_fulltext}
\alias{plos_fulltext}
\alias{print.plosft}
\title{Get full text xml of PLOS papers given a DOI}
\usage{
plos_fulltext(doi, ...)

\method{print}{plosft}(x, ...)
}
\arguments{
\item{doi}{One or more DOIs}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}

\item{x}{Input to print method}
}
\value{
Character string of XML.
}
\description{
Get full text xml of PLOS papers given a DOI
}
\examples{
\dontrun{
plos_fulltext(doi='10.1371/journal.pone.0086169')
plos_fulltext(c('10.1371/journal.pone.0086169',
  '10.1371/journal.pbio.1001845'))
dois <- searchplos(q = "*:*", 
  fq = list('doc_type:full', 'article_type:"Research Article"'), 
  limit = 3)$data$id
out <- plos_fulltext(dois)
out[dois[1]]
out[1:2]

# Extract text from the XML strings - xml2 package required
if (requireNamespace("xml2")) {
  library("xml2")
  lapply(out, function(x){
    tmp <- xml2::read_xml(x)
    xml2::xml_find_all(tmp, "//ref-list//ref")
  })
}

}
}
