% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/msa.R
\name{write.msa}
\alias{write.msa}
\title{Writing MSA Objects to Files}
\usage{
write.msa(x, file=NULL,
format=ifelse((f <- guess.format.msa(file, method="extension"))=="UNKNOWN", "FASTA", f),
pretty.print=FALSE)
}
\arguments{
\item{x}{an object of class msa}

\item{file}{File to write (will be overwritten).  If NULL, output
goes to terminal.}

\item{format}{format to write MSA object.  Valid values are "FASTA",
"PHYLIP", "MPM", or "SS".}

\item{pretty.print}{Whether to pretty-print alignment (turning
bases which match the first base in the same column to ".").}
}
\description{
Writes a multiple sequence alignment (MSA) object to a file
in one of several formats.
}
\note{
pretty.print does not work if format="SS".
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{FASTA}
\keyword{MPM}
\keyword{PHYLIP}
\keyword{SS}
\keyword{msa}

