% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/hmm.R
\name{read.hmm}
\alias{read.hmm}
\title{Read an HMM object from a file}
\usage{
read.hmm(filename)
}
\arguments{
\item{filename}{The file to read}
}
\value{
An hmm object
}
\description{
This function uses phast's internal hmm format, which is quite
simple.  See \code{write.hmm} or file used in example below for
exaples of hmm format.
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
file <- "coding.hmm"
unzip(exampleArchive, file)
# this is a 5-state hmm with states representing
# intergenic, intron, first, second, and third codon positions.
h <- read.hmm(file)
h
unlink(file)
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{hmm}

